/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xtriodef.h
 * -----------------------------------------------------------------*/

#ifndef XTRIODEFS_H_INCLUDED
#define XTRIODEFS_H_INCLUDED

/* trigger IO sequencer properties                                   */

/* generic trigger IO sequencer properties */

#define BX_TRIGIOSEQGENPROP_SIZE     14

CLI typedef enum {
    BX_TRIGIOSEQGEN_OUT_0,        /*@io0       */
    BX_TRIGIOSEQGEN_OUT_1,        /*@io1       */
    BX_TRIGIOSEQGEN_OUT_2,        /*@io2       */
    BX_TRIGIOSEQGEN_OUT_3,        /*@io3       */
    BX_TRIGIOSEQGEN_OUT_4,        /*@io4       */
    BX_TRIGIOSEQGEN_OUT_5,        /*@io5       */
    BX_TRIGIOSEQGEN_OUT_6,        /*@io6       */
    BX_TRIGIOSEQGEN_OUT_7,        /*@io7       */
    BX_TRIGIOSEQGEN_OUT_8,        /*@io8       */
    BX_TRIGIOSEQGEN_OUT_9,        /*@io9       */
    BX_TRIGIOSEQGEN_OUT_10,       /*@io10      */
    BX_TRIGIOSEQGEN_OUT_11,       /*@io11      */
    BX_TRIGIOSEQGEN_CTRC_PREL,    /*@cprel     */
    BX_TRIGIOSEQGEN_CTRD_PREL     /*@dprel     */
} bx_trigioseqgenproptype;

CLI /* DEF_START ~G_BX_TRIGIO */
#define BX_TRIGIO_INPONLY    0    /* @inponly */
#define BX_TRIGIO_TOTEMPOLE    1    /* @totempole */
#define BX_TRIGIO_OPENDRAIN    2    /* @opendrain */
CLI /* DEF_END */


/* integer based trigger io sequencer transient properties */

#define BX_TRIGIOSEQTRANPROP_SIZE     2

CLI typedef enum {
    BX_TRIGIOSEQ_STATE,          /* @state     */
    BX_TRIGIOSEQ_NEXTSTATE       /* @nextstate */
} bx_trigioseqtranproptype;


/* string based trigger io sequencer transient properties */

#define BX_TRIGIOSEQCONDPROP_SIZE     19

CLI typedef enum {
    BX_TRIGIOSEQ_XCOND,          /* @x         */
    BX_TRIGIOSEQ_OUT_0,          /* @out0      */
    BX_TRIGIOSEQ_OUT_1,          /* @out1      */
    BX_TRIGIOSEQ_OUT_2,          /* @out2      */
    BX_TRIGIOSEQ_OUT_3,          /* @out3      */
    BX_TRIGIOSEQ_OUT_4,          /* @out4      */
    BX_TRIGIOSEQ_OUT_5,          /* @out5      */
    BX_TRIGIOSEQ_OUT_6,          /* @out6      */
    BX_TRIGIOSEQ_OUT_7,          /* @out7      */
    BX_TRIGIOSEQ_OUT_8,          /* @out8      */
    BX_TRIGIOSEQ_OUT_9,          /* @out9      */
    BX_TRIGIOSEQ_OUT_10,         /* @out10     */
    BX_TRIGIOSEQ_OUT_11,         /* @out11     */
    BX_TRIGIOSEQ_CDEC,           /* @cdec      */
    BX_TRIGIOSEQ_CINC,           /* @cinc      */
    BX_TRIGIOSEQ_CLOAD,          /* @cload     */
    BX_TRIGIOSEQ_DDEC,           /* @ddec      */
    BX_TRIGIOSEQ_DINC,           /* @dinc      */
    BX_TRIGIOSEQ_DLOAD           /* @dload     */
} bx_trigioseqtrancondproptype;



#endif




